'$INCLUDE: 'v12.bi'

SUB IsInToolChest (Item)

'--- Returns Menu Item of 0 if none

          Item = 0
          MousePoll row, col, dummy, dummy
          Left = ToolChestBox(1)
          Top = ToolChestBox(2)
          Right = Left + ToolChestBox(3)
          Bottom = Top + ToolChestBox(4) * ToolChestBox(5)
          IF row < Top OR row > Bottom THEN EXIT SUB
          IF col < Left OR col > Right THEN EXIT SUB
          Item = (row - Top) \ ToolChestBox(4) + 1

END SUB

SUB PopUpMenu (Menu$(), Item)
DIM Box1(5)

'--- figure out where the cursor is

          CALL MousePoll(row, col, lb, rButton)

'--- how many items go into menu?

          Items = UBOUND(Menu$)

          High = Items * 18

'--- how wide is the widest line?

          FOR X = 1 TO Items
               Chars = LEN(Menu$(X)) * 9
               IF Chars > Wide THEN Wide = Chars
          NEXT X

'--- at this point we have width and height requirements
'--- we create an array to save the display that gets trashed by popup

          DIM ScreenSave(8 + High * Wide \ 2)

'--- Can't draw off the screen
          IF row + High > 479 THEN row = 479 - High
          IF col + Wide > 639 THEN col = 639 - Wide

          MouseHide

          GET (col, row)-STEP(Wide, High), ScreenSave

          VIEW (col, row)-(col + Wide, row + High), 0

          PR.CharClr = 15
          SetFont 8, 0

          FOR X = 0 TO Items - 1
               BoxMake 0, (X * 18), Wide, 17, 0, 1
               prPrint 5, X * 18 + 5, Menu$(X + 1)
               NEXT X

          CALL MouseBorder(row, col, row + High - 1, col + Wide)
               Selected = -1

'--- Main Loop

          DO
               CALL MousePoll(X, Y, lb, rButton)
               Current = (X - row) \ 18
               IF Current <> Selected THEN
                    BoxMake 0, (Current * 18), Wide, 17, 0, 0
                    BoxMake 0, (Selected * 18), Wide, 17, 0, 1
                    Selected = Current
                    Item = Selected + 1
               END IF
               LOOP WHILE rButton

'--- Right button has been released exit sub

          CLS
          VIEW
          PUT (col, row), ScreenSave
          CALL MouseBorder(0, 0, 479, 639)
          CALL MouseShow

END SUB

SUB ToolChest (Menu$())
REDIM ToolChestBox(5)
REDIM Box1(5)

'--- Save off parameters so we can put them back afterward

          Height_save = PR.Height
          Slant_save = PR.ItalicSlant
          X_save = PR.StepX
          Y_save = PR.StepY

'--- Set up font parameters, allow only 8 and 14 high

          SELECT CASE PR.Height

               CASE IS < 14
                    PR.Height = 8
                    PR.StepX = 7
                    Factor = 12
                    TitleBoxHeight = 12
                    TextTop = 6
                    FudgeFactor = 7
               CASE IS >= 14
                    PR.Height = 14
                    PR.StepX = 8
                    Factor = 16
                    TitleBoxHeight = 16
                    TextTop = 5
                    FudgeFactor = 0
          END SELECT

'--- See how many menu items

          Items = UBOUND(Menu$)

'--- Menu$(0) is the title if any

          IF Menu$(0) = "" THEN Bottom = 1 ELSE Bottom = 0

'--- Calculate width based on number of characters

          FOR X = Bottom TO Items
               IF LEN(Menu$(X)) > Chars THEN Chars = LEN(Menu$(X))
          NEXT X

'--- Need a fudge factor if title is widest entry
          IF LEN(Menu$(0)) >= Chars THEN Chars = Chars + 1

          High = Items * Factor
          Wide = (Chars + 1) * PR.StepX + 4

          Top = 3

          MouseHide

'--- if there is a title to display do it now

          IF Bottom = 0 THEN
               LoadArrayBox Box1(), 4, 2, Wide, TitleBoxHeight, 1
               EraseBox Box1()
               BoxOut Box1()
               TitleWidth = (LEN(Menu$(0)) + 1) * PR.StepX
               Indent = (Wide - TitleWidth) \ 2 + FudgeFactor
               prPrint Indent, 5, Menu$(0)
               Top = Top + TitleBoxHeight
               TextTop = TextTop + TitleBoxHeight
          END IF

'--- Make the box for the menu

          LoadArrayBox Box1(), 4, Top, Wide, High, 7
          EraseBox Box1()
          BoxFill Box1()
          Box1(5) = 2
          BoxOut Box1()

'--- Fill in menu items

          PR.ItalicSlant = 2
          FOR X = 0 TO Items - 1
               LINE (4, X * Factor + Top)-STEP(Wide, 0), 0
               prPrint 10, X * Factor + TextTop, Menu$(X + 1)
               NEXT X

'--- Now put it all back the way it was

          PR.Height = Height_save
          PR.ItalicSlant = Slant_save
          PR.StepX = X_save
          PR.StepY = Y_save

          ToolChestBox(1) = 4
          ToolChestBox(2) = Top
          ToolChestBox(3) = Wide
          ToolChestBox(4) = Factor
          ToolChestBox(5) = Items

          MouseShow

END SUB

